#include "vtk.hh"

main ()
{
  vtkRenderMaster rm;
  vtkRenderWindow *renWin=rm.MakeRenderWindow();
  vtkRenderer *aren=renWin->MakeRenderer();
  vtkRenderWindowInteractor *iren=renWin->MakeRenderWindowInteractor();

  // create visualization network
  vtkSphereSource sphere;
  sphere.SetRadius(0.75);

  vtkShrinkPolyData shrink;
  shrink.SetInput(sphere.GetOutput());
  shrink.SetShrinkFactor(0.9);

  vtkPolyMapper mapper;
  mapper.SetInput(shrink.GetOutput());

  vtkActor actor;
  actor.SetMapper(mapper);
  actor.GetProperty()->SetColor(1,0.39,0.28);

  // render sphere
  aren->AddActors(&actor);
  aren->SetBackground(.1,.2,.4);
  renWin->Render();

  iren->Start();
}
